
class HGPlasmaSphere extends Projectile;

#exec OBJ LOAD FILE=textures\GoRelics.utx PACKAGE=HealingGunBeta.PlasmaExplo

var bool bExploded, bExplosionEffect, bHitPawn;
var() texture ExpType;
var() Sound EffectSound1;
var() texture SpriteAnim[20];
var() int NumFrames;
var Float AnimTime;

simulated function PostBeginPlay()
{
    Super.PostBeginPlay();
    SetTimer(0.8, true);
    if ( Level.NetMode == NM_Client )
        LifeSpan = 2.0;
    else
        Velocity = Speed * vector(Rotation);
    if ( Level.bDropDetail )
        LightType = LT_None;
}

simulated function Timer()
{
    if ( Level.bDropDetail )
        LightType = LT_None;
    if ( (Physics == PHYS_None) && (LifeSpan > 0.5) )
        LifeSpan = 0.5;
}

simulated function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
                    Vector momentum, name damageType)
{
    bExploded = True;
}

function BlowUp(vector HitLocation)
{
    PlaySound(EffectSound1,,7.0);   
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
    if ( !bExplosionEffect )
    {
        if ( Role == ROLE_Authority )
            BlowUp(HitLocation);
        bExplosionEffect = true;
        if ( !Level.bHighDetailMode || bHitPawn || Level.bDropDetail )
        {
            if ( bExploded )
            {
                Destroy();
                return;
            }
            else
                DrawScale = 0.45;
        }
        else
        DrawScale = 0.65;
        LightType = LT_Steady;
        LightRadius = 5;
        SetCollision(false,false,false);
        LifeSpan = 0.5;
        Texture = ExpType;
        DrawType = DT_SpriteAnimOnce;
        Style = STY_Translucent;
        if ( Region.Zone.bMoveProjectiles && (Region.Zone.ZoneVelocity != vect(0,0,0)) )
        {
            bBounce = true;
            Velocity = Region.Zone.ZoneVelocity;
        }
        else
            SetPhysics(PHYS_None);
    }
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
    If ( Other!=Instigator  && PlasmaSphere(Other)==None )
    {
        if ( Other.bIsPawn )
        {
            bHitPawn = true;
            bExploded = !Level.bHighDetailMode || Level.bDropDetail;
        }
        if ( Role == ROLE_Authority )
            Other.TakeDamage( Damage, instigator, HitLocation, MomentumTransfer*Vector(Rotation), MyDamageType);    
        Explode(HitLocation, vect(0,0,1));
    }
}

auto State Flying
{
Begin:
    LifeSpan = 2.0;
}

defaultproperties
{
     ExplosionDecal=class'UMBoltScorch'
     MyDamageType=Pulsed
     SpriteAnim(0)=Texture'HGpblst00'
     SpriteAnim(1)=Texture'HGpblst01'
     SpriteAnim(2)=Texture'HGpblst02'
     SpriteAnim(3)=Texture'HGpblst03'
     SpriteAnim(4)=Texture'HGpblst04'
     SpriteAnim(5)=Texture'HGpblst04'
     SpriteAnim(6)=Texture'HGpblst03'
     SpriteAnim(7)=Texture'HGpblst02'
     SpriteAnim(8)=Texture'HGpblst01'
     SpriteAnim(9)=Texture'HGpblst00'
     SpriteAnim(10)=Texture'HGpblst01'
     NumFrames=11
     EffectSound1=Sound'PulseExp'
     speed=1450.000000
     MomentumTransfer=10000
     ExploWallOut=10.000000
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=0.500000
     Style=STY_Translucent
     DrawScale=0.190000
     AmbientGlow=187
     bUnlit=True
     SoundRadius=10
     SoundVolume=218
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightRadius=3
     LightBrightness=255
     LightHue=0
     LightSaturation=0
     bFixedRotationDir=True
     ExpType=Texture'HGpblst00'
     Damage=30.000000
     DrawType=DT_Sprite
     Texture=Texture'HGpblst00'
}

